/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Last Modification:
    @version $Id: SIIIM_HAL.h 36958 2013-07-31 13:39:49Z Sven $

  Changes:

      Version    Date         Author    Description
      ---------------------------------------------------------------------------
      1         2013-08-22    sb        created

-------------------------------------------------------------------------------

*******************************************************************************/

#ifndef SIIIM_SCP_SYSTIME_CONTROL_H_INCLUDED
#define SIIIM_SCP_SYSTIME_CONTROL_H_INCLUDED

#include <stdint.h>

/*---------------------------------------------------------------------------*/
/* Compiler settings */
#if _MSC_VER >= 1000
  #define __SIIIM_SCP_SYSTIME_PACKED_PRE
  #define __SIIIM_SCP_SYSTIME_PACKED_POST
  #define __SIIIM_SCP_SYSTIME_PACKED_POST_ALIGN2
  #pragma once
  #pragma pack(1)            /* Always align structures to byte boundery */
  #ifndef STRICT             /* Check Typdefinition */
    #define STRICT
  #endif
#endif /* _MSC_VER >= 1000 */

/* support for GNU compiler */
#ifdef __GNUC__
  #define __SIIIM_SCP_SYSTIME_PACKED_PRE
  #define __SIIIM_SCP_SYSTIME_PACKED_POST    __attribute__((packed))
  #define __SIIIM_SCP_SYSTIME_PACKED_POST_ALIGN2 __attribute__((packed,aligned(2)))
#endif

/* support for REALVIEW ARM compiler */
#if defined (__ADS__) || defined (__REALVIEW__)
  #define __SIIIM_SCP_SYSTIME_PACKED_PRE   __packed
  #define __SIIIM_SCP_SYSTIME_PACKED_POST
  #define __SIIIM_SCP_SYSTIME_PACKED_POST_ALIGN2
#endif

typedef __SIIIM_SCP_SYSTIME_PACKED_PRE struct
{
  uint16_t usConnCtrl;
  /* time stamp refers to next cycle start */
  uint16_t usCommand;
  uint32_t ulSercosTimeNs;
  uint32_t ulSercosTimeS;
  uint32_t ul64BitTimeLow;
  uint32_t ul64BitTimeHigh;
} __SIIIM_SCP_SYSTIME_PACKED_POST_ALIGN2 SIIIM_SCP_SYSTIME_CONTROL_CONNECTION_T;

typedef enum
{
  SIIIM_SCP_SYSTIME_CMD_SET_SERCOS_TIME,
  SIIIM_SCP_SYSTIME_CMD_SET_64BIT_TIME,
  SIIIM_SCP_SYSTIME_CMD_ENABLE_TRANSMIT,
  SIIIM_SCP_SYSTIME_CMD_DISABLE_TRANSMIT,
} SIIIM_SCP_SYSTIME_COMMAND_E;

typedef __SIIIM_SCP_SYSTIME_PACKED_PRE struct
{
  uint16_t usConnCtrl;
  uint16_t usStatus;
  /* time stamp refers to tMST of active cycle */
  uint32_t ulSercosTimeNs;
  uint32_t ulSercosTimeS;
  uint32_t ul64BitTimeLow;
  uint32_t ul64BitTimeHigh;
} __SIIIM_SCP_SYSTIME_PACKED_POST_ALIGN2 SIIIM_SCP_SYSTIME_STATUS_CONNECTION_T;

enum
{
  MSK_SCP_SYSTIME_STAT_TRANSMIT_ENABLED = 0x0001,
  MSK_SCP_SYSTIME_STAT_TRANSMIT_ACTIVE = 0x0002,
};

#endif
